(
	-- RGB Multiply

    struct AMGData 
	(
		fn GetUUID mtl context = 
		(
			"129a5bfc-72e3-4e69-bc0f-7dcc5a2adf26"
		),

		fn GetMaps mtl context =
		(
			local res = #()	

			local out = "result"
			if (context == 1) do out = "normalPerturb" -- bump mode
			
			if mtl.map1 != undefined and mtl.map1enabled do 
			(
				append res #("Color1", mtl.map1, out)
				append res #("Alpha1", mtl.map1, "alpha")
				append res #("Float1", mtl.map1, "resultFloat")
			)
			if mtl.map2 != undefined and mtl.map2enabled do 
			(
				append res #("Color2", mtl.map2, out)
				append res #("Alpha2", mtl.map2, "alpha")
				append res #("Float2", mtl.map2, "resultFloat")
			)

			append res #("UVW",      mtl.coords, "result")
			append res #("utangent", mtl.coords, "utangent") 
			append res #("vtangent", mtl.coords, "vtangent") 
			append res #("wtangent", mtl.coords, "wtangent") 

			res
		),

		fn GetParams mtl context = 
		(
			local res = #()	

			append res #("Color1", mtl.color1)
			append res #("Color2", mtl.color2)
			append res #("Alpha1", 1.0)
			append res #("Alpha2", 1.0)
			append res #("Float1", (mtl.color1.r+mtl.color1.g+mtl.color1.b)/768.0)
			append res #("Float2", (mtl.color2.r+mtl.color2.g+mtl.color2.b)/768.0)
			append res #("Map1on", mtl.map1 != undefined and mtl.map1enabled)
			append res #("Map2on", mtl.map2 != undefined and mtl.map2enabled)

			append res #("scale",     1.0/mtl.size)
			append res #("levels",    mtl.levels)
			append res #("lowThresh", mtl.thresholdLow)
			append res #("hiThresh",  mtl.thresholdHigh)
			append res #("type",      mtl.type)
			append res #("phase",     mtl.phase)

			-- Output parameters
			append res #( "invert",			mtl.output.invert)                   
			append res #( "clamp",			mtl.output.clamp )  
			append res #( "rgb_level",		mtl.output.RGB_Level )  
			append res #( "rgb_offset",		mtl.output.RGB_Offset )  
			append res #( "out_amount",		mtl.output.Output_Amount )  
			append res #( "bump_amount",	mtl.output.Bump_Amount)  
			append res #( "alpha_from_rgb",	mtl.output.alphaFromRGB)  
			append res #( "curves",			mtl,   "output" )  -- Attach and translate the "output" rollout
				
 			res
		)
	)
	AMGData()
)

-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEDUAFkMQxqI9PltZ2eUG16Ew
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTkwNjI1MDAwMDAwWhcNMjAwODA3MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBAMsptjSEm+HPve6+DClr+K4CgrtrONjtHxHBwTMC
-- mrwF9bnsdMiSgvYigTKk858TlqVs7GiBVLD3SaSZqfSXOv7L55i965L+wIx0EZxX
-- xDzbyLh1rLSSNWO8oTDIKnPsiwo5x7CHRUi/eAICOvLmz7Rzi+becd1j/JPNWe5t
-- vum0GL/8G4vYICrhCycizGIuv3QFqv0YPM75Pd2NP0V4W87XPeTrj+qQoRKMztJ4
-- WNDgLgT4LbMBIZyluU8iwXNyWQ8FC2ya3iJyy0EhZhAB2H7oMrAcV1VJJqwZcZQU
-- XMJTD+tuCqKqJ1ftv1f0JVW2AADnHgvaB6E6Y9yR/jnn4zECAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBADo7
-- 6cASiVbzkjsADk5MsC3++cj9EjWeiuq+zzKbe55p6jBNphsqLUvMw+Z9r2MpxTEs
-- c//MNUXidFsslWvWAUeOdtytNfhdyXfENX3baBPWHhW1zvbOPHQLyz8LmR1bNe9f
-- R1SLAezJaGzeuaY/Cog32Jh4qDyLSzx87tRUJI2Ro5BLA5+ELiY21SDZ7CP9ptbU
-- CDROdHY5jk/WeNh+3gLHeikJSM9/FPszQwVc9mjbVEW0PSl1cCLYEXu4T0o09ejX
-- NaQPg10POH7FequNcKw50L63feYRStDf6GlO4kNXKFHIy+LPdLaSdCQL2/oi3edV
-- MdpL4F7yw1zQBzShYMoxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQNQAWQxDGoj0+W1nZ5QbXoTANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQByCF2AUDKHgaNMM9Fdn0nIMSUfQTyfq/uu
-- KO9LNzkfgRqhJV9jzVw4/hbgcbF49phcyKsai9GXZMCH019vdHn6wkrWEGIlV9aq
-- HSNBe8SzHQ/blAi56oZhHFNcz2FK6qDITklw/oM5MkNyIxw6Sl7jNkJ9qOBo4wU0
-- Dmq2nRR0EOslHJNXybWbEgIlOc8TrQW/aLvWB/GaC9c9rqdELMw9sFpf00Cc4YF2
-- ZZbCXVh0/aFAQqjGZrOqsW4tec3enJ1YwWJZNHAavV6k/xbxhvkyoGjj8qKTTf9c
-- lH4AYWWR1lWFKq7QGc6GIIas5gYCMdH2Zd5qUZcIgKRF37CZXUXy
-- -----END-SIGNATURE-----